package w83b.w83bBeans;

import java.sql.ResultSet;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bRespAreaBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bRespAreaBean.
 * 
 * @author jroncal
 */
public class W83bRespAreaBean extends W83bBaseBean implements W83bBaseBeanBD{
	
	/** The Constant serialVersionUID. */
	private static final long	serialVersionUID	= 1L;

	/** The codigo responsable. */
	private String	codigoResponsable = "";
	
	/** The nombre responsable. */
	private String	nombreResponsable = "";
	
	/** The territorio. */
	private String	territorio = "";
	
	/** The territorio desc. */
	private String	territorioDesc = "";
	
	/** The perfil id. */
	private String	perfilId = "";
	
	/** The perfil sscc. */
	private String	perfilSSCC = "";
	
	/** The perfil desc. */
	private String	perfilDesc = "";
	
	/** The perfil desc eusk. */
	private String	perfilDescEusk = "";
	
	/** The baja. */
	private String baja="";
	
	private String sexoResponsable="";

	
	/**
	 * Instantiates a new w83b resp area bean.
	 */
	public W83bRespAreaBean() {
		super();
	}

	/**
	 * Sets the territorio.
	 *
	 * @param territorio the new territorio
	 */
	public void setTerritorio(String territorio) {
		this.territorio = territorio;
	}

	/**
	 * Gets the nombre territorio.
	 *
	 * @param pCod the cod
	 * @return the nombre territorio
	 */
	public String getNombreTerritorio(String pCod) {
		String nombreTerritorio;
		if(W83bClsConstantes.CONSTANTE_ALAVA.equalsIgnoreCase(pCod)){
			nombreTerritorio="LAVA/ARABA";
		}else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equalsIgnoreCase(pCod)){
			nombreTerritorio="GIPUZKOA";
		}else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equalsIgnoreCase(pCod)){
			nombreTerritorio="BIZKAIA";
		}else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equalsIgnoreCase(pCod)){
			nombreTerritorio= "SERVICIOS CENTRALES";
		}else{
			nombreTerritorio="";
		}
		return nombreTerritorio;
	}
	
	/**
	 * Gets the territorio.
	 *
	 * @return the territorio
	 */
	public String getTerritorio() {
		return this.territorio;
	}
	
	/**
	 * Sets the territorio desc.
	 *
	 * @param territorioDesc the new territorio desc
	 */
	public void setTerritorioDesc(String territorioDesc) {
		this.territorioDesc = territorioDesc;
	}

	/**
	 * Gets the territorio desc.
	 *
	 * @return the territorio desc
	 */
	public String getTerritorioDesc() {
		return territorioDesc;
	}

	/**
	 * Gets the codigo responsable.
	 *
	 * @return the codigo responsable
	 */
	public String getCodigoResponsable() {
		return codigoResponsable;
	}

	/**
	 * Sets the codigo responsable.
	 *
	 * @param codigoResponsable the new codigo responsable
	 */
	public void setCodigoResponsable(String codigoResponsable) {
		this.codigoResponsable = codigoResponsable;
	}

	/**
	 * Gets the nombre responsable.
	 *
	 * @return the nombre responsable
	 */
	public String getNombreResponsable() {
		return nombreResponsable;
	}

	/**
	 * Sets the nombre responsable.
	 *
	 * @param nombreResponsable the new nombre responsable
	 */
	public void setNombreResponsable(String nombreResponsable) {
		this.nombreResponsable = nombreResponsable;
	}

	/**
	 * Gets the perfil id.
	 *
	 * @return the perfil id
	 */
	public String getPerfilId() {
		return perfilId;
	}

	/**
	 * Sets the perfil id.
	 *
	 * @param perfilId the new perfil id
	 */
	public void setPerfilId(String perfilId) {
		this.perfilId = perfilId;
	}

	/**
	 * Sets the perfil sscc.
	 *
	 * @param perfilSSCC the new perfil sscc
	 */
	public void setPerfilSSCC(String perfilSSCC) {
		this.perfilSSCC = perfilSSCC;
	}

	/**
	 * Gets the perfil sscc.
	 *
	 * @return the perfil sscc
	 */
	public String getPerfilSSCC() {
		return perfilSSCC;
	}
	
	/**
	 * Gets the perfil desc.
	 *
	 * @return the perfil desc
	 */
	public String getPerfilDesc() {
		return perfilDesc;
	}

	/**
	 * Sets the perfil desc.
	 *
	 * @param perfilDesc the new perfil desc
	 */
	public void setPerfilDesc(String perfilDesc) {
		this.perfilDesc = perfilDesc;
	}

	/**
	 * Sets the perfil desc eusk.
	 *
	 * @param perfilDescEusk the new perfil desc eusk
	 */
	public void setPerfilDescEusk(String perfilDescEusk) {
		this.perfilDescEusk = perfilDescEusk;
	}

	/**
	 * Gets the perfil desc eusk.
	 *
	 * @return the perfil desc eusk
	 */
	public String getPerfilDescEusk() {
		return perfilDescEusk;
	}

	/**
	 * Gets the baja.
	 *
	 * @return the baja
	 */
	public String getBaja() {
		return baja;
	}

	/**
	 * Sets the baja.
	 *
	 * @param baja the new baja
	 */
	public void setBaja(String baja) {
		this.baja = baja;
	}

	public String getSexoResponsable() {
		return sexoResponsable;
	}

	public void setSexoResponsable(String sexoResponsable) {
		this.sexoResponsable = sexoResponsable;
	}

	/* (non-Javadoc)
	 * @see w83b.w83bBeans.W83bBaseBeanBD#rowToBean(java.lang.Object, java.lang.Object)
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		// TODO Auto-generated method stub
		ResultSet rs = (ResultSet)o;//NOPMD
		this.territorio = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.territorio);
		if(this.territorio.equalsIgnoreCase(W83bClsConstantes.CONSTANTE_ALAVA)){
			this.territorioDesc = "LAVA/ARABA";
		}else if(this.territorio.equalsIgnoreCase(W83bClsConstantes.CONSTANTE_GIPUZKOA)){
			this.territorioDesc = "GIPUZKOA";
		}else if(this.territorio.equalsIgnoreCase(W83bClsConstantes.CONSTANTE_BIZKAIA)){
			this.territorioDesc = "BIZKAIA";
		}else if(this.territorio.equalsIgnoreCase(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES)){
			if(otrosValores!=null){
				this.territorioDesc = (String) otrosValores;
			}else{
				this.territorioDesc = "SERVICIOS CENTRALES";
			}
		}
		this.codigoResponsable = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.codigoResponsable);
		this.nombreResponsable = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.nombreResponsable);
		this.perfilId = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.perfilId);
		this.perfilSSCC = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.isPerfilCentrales);
		this.perfilDesc = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.perfilDesc).toUpperCase();
		this.perfilDescEusk = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.perfilDescEus).toUpperCase();
		this.sexoResponsable = W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.sexo);
		if(StringUtils.isNotEmpty(W83bDataBase.getStringFromRS(rs, W83bRespAreaBD.baja))){
			this.baja = W83bClsConstantes.BAJA ;
		}else{
			this.baja = "";
		}
		return this;
	}
}